/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.translate.impl.libretranslate;

import io.gitlab.jfronny.commons.http.client.HttpClient;
import io.gitlab.jfronny.commons.serialize.json.JsonReader;
import io.gitlab.jfronny.libjf.LibJf;
import io.gitlab.jfronny.libjf.translate.api.TranslateException;
import io.gitlab.jfronny.libjf.translate.impl.AbstractTranslateService;
import io.gitlab.jfronny.libjf.translate.impl.Throttle;
import io.gitlab.jfronny.libjf.translate.impl.libretranslate.model.GC_LibreTranslateDetectResult;
import io.gitlab.jfronny.libjf.translate.impl.libretranslate.model.GC_LibreTranslateLanguage;
import io.gitlab.jfronny.libjf.translate.impl.libretranslate.model.GC_LibreTranslateResult;
import io.gitlab.jfronny.libjf.translate.impl.libretranslate.model.LibreTranslateDetectResult;
import io.gitlab.jfronny.libjf.translate.impl.libretranslate.model.LibreTranslateLanguage;
import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class LibreTranslateService
extends AbstractTranslateService<LibreTranslateLanguage> {
    public static final String NAME = "LibreTranslate";
    private static final Map<String, LibreTranslateService> knownInstances = new HashMap<String, LibreTranslateService>();
    private final String host;
    private final List<LibreTranslateLanguage> knownLanguages;
    private final Map<String, LibreTranslateLanguage> languageById = new HashMap<String, LibreTranslateLanguage>();
    private final Throttle throttle = new Throttle();

    public static LibreTranslateService get(String host) throws TranslateException {
        LibreTranslateService lts;
        Objects.requireNonNull(host, "host");
        if (knownInstances.containsKey(host)) {
            LibreTranslateService lts2 = knownInstances.get(host);
            if (lts2 == null) {
                throw new TranslateException("Translate service previously failed to initialize. Not trying again");
            }
            return lts2;
        }
        try {
            lts = new LibreTranslateService(host);
        }
        catch (TranslateException e) {
            knownInstances.put(host, null);
            throw new TranslateException("Could not instantiate translate service", e);
        }
        knownInstances.put(host, lts);
        return lts;
    }

    private LibreTranslateService(String host) throws TranslateException {
        if (Objects.requireNonNull(host, "host").endsWith("/")) {
            host = host.substring(0, host.length() - 1);
        }
        this.host = host;
        this.throttle.waitForNextRequest();
        try (Reader r = HttpClient.get((String)(host + "/languages")).sendReader();
             JsonReader jr = LibJf.LENIENT_TRANSPORT.createReader(r);){
            List langs = jr.arrayByElements(GC_LibreTranslateLanguage::deserialize);
            for (LibreTranslateLanguage lang : langs) {
                this.languageById.put(lang.code().toLowerCase(Locale.ROOT), lang);
            }
            langs.add(LibreTranslateLanguage.AUTO_DETECT);
            this.knownLanguages = List.copyOf(langs);
        }
        catch (IOException | URISyntaxException e) {
            throw new TranslateException("Could not get known languages for LibreTranslate backend", e);
        }
    }

    @Override
    protected LibreTranslateLanguage getAutoDetectLang() {
        return LibreTranslateLanguage.AUTO_DETECT;
    }

    @Override
    protected String performTranslate(String textToTranslate, LibreTranslateLanguage translateFrom, LibreTranslateLanguage translateTo) throws Exception {
        this.throttle.waitForNextRequest();
        try (Reader r = HttpClient.post((String)(this.host + "/translate")).bodyForm(Map.of("q", textToTranslate, "source", translateFrom.getIdentifier(), "target", translateTo.getIdentifier())).sendReader();){
            String string;
            block12: {
                JsonReader jr = LibJf.LENIENT_TRANSPORT.createReader(r);
                try {
                    string = Objects.requireNonNull(GC_LibreTranslateResult.deserialize(jr)).translatedText();
                    if (jr == null) break block12;
                }
                catch (Throwable throwable) {
                    if (jr != null) {
                        try {
                            jr.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jr.close();
            }
            return string;
        }
    }

    @Override
    public LibreTranslateLanguage detect(String text) throws TranslateException {
        List result;
        this.throttle.waitForNextRequest();
        try (Reader r = HttpClient.post((String)(this.host + "/detect")).bodyForm(Map.of("q", text)).sendReader();
             JsonReader jr = LibJf.LENIENT_TRANSPORT.createReader(r);){
            result = jr.arrayByElements(GC_LibreTranslateDetectResult::deserialize);
        }
        catch (IOException | URISyntaxException e) {
            throw new TranslateException("Could not detect language", e);
        }
        LibreTranslateDetectResult resCurr = null;
        for (LibreTranslateDetectResult res : result) {
            if (resCurr != null && !(res.confidence() > resCurr.confidence())) continue;
            resCurr = res;
        }
        if (resCurr == null) {
            throw new TranslateException("Could not identify any valid language");
        }
        return this.parseLang(resCurr.language());
    }

    @Override
    public LibreTranslateLanguage parseLang(String lang) {
        if (lang == null || lang.isBlank()) {
            return LibreTranslateLanguage.AUTO_DETECT;
        }
        lang = lang.trim().toLowerCase(Locale.ROOT);
        return this.languageById.getOrDefault(lang, LibreTranslateLanguage.AUTO_DETECT);
    }

    @Override
    public List<LibreTranslateLanguage> getAvailableLanguages() {
        return this.knownLanguages;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

